/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Pedidos;
import project.fastfood.Entity.SesionCaja;
import project.fastfood.Entity.Sucursales;
import project.fastfood.Entity.Ventas;
import project.fastfood.Entity.VentasDTO;
import project.fastfood.Repository.PedidoRepository;
import project.fastfood.Repository.SesionCajaRepository;
import project.fastfood.Repository.SucursalRepository;
import project.fastfood.Service.IVentasService;

@RestController
@RequestMapping(value={"/fastfood"})
public class VentaController {
    @Autowired
    private IVentasService ventaService;
    @Autowired
    private PedidoRepository repoPedido;
    @Autowired
    private SesionCajaRepository repoSesionCaja;
    @Autowired
    private SucursalRepository repoSucursal;

    @GetMapping(value={"ventas"})
    public List<Ventas> buscarTodo() {
        return this.ventaService.buscarTodo();
    }

    @PostMapping(value={"/ventas"})
    public ResponseEntity<?> guardar(@RequestBody VentasDTO dto) {
        Ventas venta = new Ventas();
        venta.setTipo_comprobante(dto.getTipo_comprobante());
        venta.setNumero_comprobante(dto.getNumero_comprobante());
        venta.setFecha_emision(dto.getFecha_emision());
        venta.setTotal_venta(dto.getTotal_venta());
        venta.setEstado_venta(dto.getEstado_venta());
        Pedidos pedido = this.repoPedido.findById((Object)dto.getId_pedido()).orElse(null);
        SesionCaja sesion = this.repoSesionCaja.findById((Object)dto.getId_sesion()).orElse(null);
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        venta.setId_sucursal(sucursal);
        venta.setId_sesion(sesion);
        venta.setId_pedido(pedido);
        return ResponseEntity.ok((Object)this.ventaService.guardar(venta));
    }

    @PutMapping(value={"/ventas"})
    public ResponseEntity<?> modificar(@RequestBody VentasDTO dto) {
        if (dto.getId_venta() == null) {
            return ResponseEntity.badRequest().body((Object)"Id venta es necesario para modificar");
        }
        Ventas venta = new Ventas();
        venta.setId_venta(dto.getId_venta());
        venta.setTipo_comprobante(dto.getTipo_comprobante());
        venta.setNumero_comprobante(dto.getNumero_comprobante());
        venta.setFecha_emision(dto.getFecha_emision());
        venta.setTotal_venta(dto.getTotal_venta());
        venta.setEstado_venta(dto.getEstado_venta());
        venta.setId_pedido(new Pedidos(dto.getId_pedido()));
        venta.setId_sesion(new SesionCaja(dto.getId_sesion()));
        venta.setId_sucursal(new Sucursales(dto.getId_sucursal()));
        return ResponseEntity.ok((Object)this.ventaService.modificar(venta));
    }

    @GetMapping(value={"/ventas/{id}"})
    public Optional<Ventas> buscarId(@PathVariable(value="id") Integer id) {
        return this.ventaService.buscarId(id);
    }

    @DeleteMapping(value={"/ventas/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.ventaService.eliminar(id);
        return "venta eliminada";
    }
}

