/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Empresas;
import project.fastfood.Entity.Roles;
import project.fastfood.Entity.Sucursales;
import project.fastfood.Entity.Usuarios;
import project.fastfood.Entity.UsuariosDTO;
import project.fastfood.Repository.EmpresasRepository;
import project.fastfood.Repository.RolesRepository;
import project.fastfood.Repository.SucursalRepository;
import project.fastfood.Service.IUsuariosService;

@RestController
@RequestMapping(value={"/fastfood"})
public class UsuariosController {
    @Autowired
    private IUsuariosService serviceUsuarios;
    @Autowired
    private RolesRepository repoRoles;
    @Autowired
    private SucursalRepository repoSucursal;
    @Autowired
    private EmpresasRepository repoEmpresas;

    @GetMapping(value={"/usuarios"})
    public List<Usuarios> buscartodos() {
        return this.serviceUsuarios.buscarTodos();
    }

    @PostMapping(value={"/usuarios"})
    public ResponseEntity<?> guardar(@RequestBody UsuariosDTO dto) {
        Usuarios usuario = new Usuarios();
        usuario.setNombre_completo(dto.getNombre_completo());
        usuario.setNombre_usuario(dto.getNombre_usuario());
        usuario.setPassword(dto.getPassword());
        Roles rol = this.repoRoles.findById((Object)dto.getId_rol()).orElse(null);
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        Empresas empresa = this.repoEmpresas.findById((Object)dto.getId_empresa()).orElse(null);
        usuario.setId_sucursal(sucursal);
        usuario.setId_rol(rol);
        usuario.setId_empresa(empresa);
        return ResponseEntity.ok((Object)this.serviceUsuarios.guardar(usuario));
    }

    @PutMapping(value={"/usuarios"})
    public ResponseEntity<?> modificar(@RequestBody UsuariosDTO dto) {
        if (dto.getId_usuario() == null) {
            return ResponseEntity.badRequest().body((Object)"Id usuario es necesario para modificar");
        }
        Usuarios usuario = new Usuarios();
        usuario.setId_usuario(dto.getId_usuario());
        usuario.setNombre_completo(dto.getNombre_completo());
        usuario.setNombre_usuario(dto.getNombre_usuario());
        usuario.setPassword(dto.getPassword());
        Roles rol = this.repoRoles.findById((Object)dto.getId_rol()).orElse(null);
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        Empresas empresa = this.repoEmpresas.findById((Object)dto.getId_empresa()).orElse(null);
        usuario.setId_sucursal(sucursal);
        usuario.setId_rol(rol);
        usuario.setId_empresa(empresa);
        return ResponseEntity.ok((Object)this.serviceUsuarios.modificar(usuario));
    }

    @GetMapping(value={"/usuarios/{id}"})
    public Optional<Usuarios> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceUsuarios.buscarId(id);
    }

    @DeleteMapping(value={"/usuarios/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceUsuarios.eliminar(id);
        return "Usuario eliminado";
    }
}

