/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Empresas;
import project.fastfood.Entity.Sucursales;
import project.fastfood.Entity.SucursalesDTO;
import project.fastfood.Repository.EmpresasRepository;
import project.fastfood.Service.ISucursalService;

@RestController
@RequestMapping(value={"/fastfood"})
public class SucursalesController {
    @Autowired
    private ISucursalService sucursalService;
    @Autowired
    private EmpresasRepository repoEmpresas;

    @GetMapping(value={"sucursales"})
    public List<Sucursales> buscarTodo() {
        return this.sucursalService.buscarTodo();
    }

    @PostMapping(value={"/sucursales"})
    public ResponseEntity<?> guardar(@RequestBody SucursalesDTO dto) {
        Sucursales sucursal = new Sucursales();
        sucursal.setNombre(dto.getNombre());
        sucursal.setDireccion(dto.getDireccion());
        sucursal.setDistrito(dto.getDistrito());
        sucursal.setTelefono(dto.getTelefono());
        sucursal.setEmail(dto.getEmail());
        Empresas empresa = this.repoEmpresas.findById((Object)dto.getId_empresa()).orElse(null);
        sucursal.setId_empresa(empresa);
        if (empresa == null) {
            return ResponseEntity.badRequest().body((Object)"Empresa no encontrada");
        }
        return ResponseEntity.ok((Object)this.sucursalService.guardar(sucursal));
    }

    @PutMapping(value={"/sucursales"})
    public ResponseEntity<?> modificar(@RequestBody SucursalesDTO dto) {
        if (dto.getId_sucursal() == null) {
            return ResponseEntity.badRequest().body((Object)"Id sucursal es necesario para modificar");
        }
        Sucursales sucursal = new Sucursales();
        sucursal.setId_sucursal(dto.getId_sucursal());
        sucursal.setNombre(dto.getNombre());
        sucursal.setDireccion(dto.getDireccion());
        sucursal.setDistrito(dto.getDistrito());
        sucursal.setTelefono(dto.getTelefono());
        sucursal.setEmail(dto.getEmail());
        Empresas empresa = this.repoEmpresas.findById((Object)dto.getId_empresa()).orElse(null);
        sucursal.setId_empresa(empresa);
        return ResponseEntity.ok((Object)this.sucursalService.modificar(sucursal));
    }

    @GetMapping(value={"/sucursales/{id}"})
    public Optional<Sucursales> buscarId(@PathVariable(value="id") Integer id) {
        return this.sucursalService.buscarId(id);
    }

    @DeleteMapping(value={"/sucursales/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.sucursalService.eliminar(id);
        return "Sucursal eliminada";
    }
}

