/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Cajas;
import project.fastfood.Entity.SesionCaja;
import project.fastfood.Entity.SesionCajaDTO;
import project.fastfood.Entity.Usuarios;
import project.fastfood.Repository.CajasRepository;
import project.fastfood.Repository.UsuariosRepository;
import project.fastfood.Service.ISesionCajaService;

@RestController
@RequestMapping(value={"/fastfood"})
public class SesionCajaController {
    @Autowired
    private ISesionCajaService sesionCajaService;
    @Autowired
    private CajasRepository repoCajas;
    @Autowired
    private UsuariosRepository repoUsuarios;

    @GetMapping(value={"sesioncaja"})
    public List<SesionCaja> buscarTodo() {
        return this.sesionCajaService.buscarTodos();
    }

    @PostMapping(value={"/sesioncaja"})
    public ResponseEntity<?> guardar(@RequestBody SesionCajaDTO dto) {
        SesionCaja sesion = new SesionCaja();
        sesion.setFecha_apertura(dto.getFecha_apertura());
        sesion.setFecha_cierre(dto.getFecha_cierre());
        sesion.setMonto_apertura(dto.getMonto_apertura());
        sesion.setMonto_cierre(dto.getMonto_cierre());
        Cajas caja = this.repoCajas.findById((Object)dto.getId_caja()).orElse(null);
        Usuarios usuario = this.repoUsuarios.findById((Object)dto.getId_usuario()).orElse(null);
        sesion.setId_caja(caja);
        sesion.setId_usuario(usuario);
        return ResponseEntity.ok((Object)this.sesionCajaService.guardar(sesion));
    }

    @PutMapping(value={"/sesioncaja"})
    public ResponseEntity<?> modificar(@RequestBody SesionCajaDTO dto) {
        if (dto.getId_sesion() == null) {
            return ResponseEntity.badRequest().body((Object)"Id sesion caja es necesario para modificar");
        }
        SesionCaja sesion = new SesionCaja();
        sesion.setId_sesion(dto.getId_sesion());
        sesion.setFecha_apertura(dto.getFecha_apertura());
        sesion.setFecha_cierre(dto.getFecha_cierre());
        sesion.setMonto_apertura(dto.getMonto_apertura());
        sesion.setMonto_cierre(dto.getMonto_cierre());
        Cajas caja = this.repoCajas.findById((Object)dto.getId_caja()).orElse(null);
        Usuarios usuario = this.repoUsuarios.findById((Object)dto.getId_usuario()).orElse(null);
        sesion.setId_caja(caja);
        sesion.setId_usuario(usuario);
        return ResponseEntity.ok((Object)this.sesionCajaService.modificar(sesion));
    }

    @GetMapping(value={"/sesioncaja/{id}"})
    public Optional<SesionCaja> buscarId(@PathVariable(value="id") Integer id) {
        return this.sesionCajaService.buscarId(id);
    }

    @DeleteMapping(value={"/sesioncaja/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.sesionCajaService.eliminar(id);
        return "Sesion caja eliminada";
    }
}

