/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Roles;
import project.fastfood.Service.IRolesService;

@RestController
@RequestMapping(value={"/fastfood"})
public class RolesController {
    @Autowired
    private IRolesService serviceRoles;

    @GetMapping(value={"/roles"})
    public List<Roles> buscartodos() {
        return this.serviceRoles.buscarTodos();
    }

    @PostMapping(value={"/roles"})
    public Roles guardar(@RequestBody Roles rol) {
        this.serviceRoles.guardar(rol);
        return rol;
    }

    @PutMapping(value={"/roles"})
    public Roles modificar(@RequestBody Roles rol) {
        this.serviceRoles.modificar(rol);
        return rol;
    }

    @GetMapping(value={"/roles/{id}"})
    public Optional<Roles> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceRoles.buscarId(id);
    }

    @DeleteMapping(value={"/roles/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceRoles.eliminar(id);
        return "rol eliminado";
    }
}

