/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Registros;
import project.fastfood.Security.JwtUtil;
import project.fastfood.Service.IRegistrosService;

@RestController
@RequestMapping(value={"/fastfood"})
public class RegistrosController {
    @Autowired
    private IRegistrosService registroService;
    @Autowired
    private JwtUtil jwtutil;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;

    @GetMapping(value={"registros"})
    public List<Registros> buscarTodo() {
        return this.registroService.buscarTodo();
    }

    @PostMapping(value={"/registros"})
    public Registros guardar(@RequestBody Registros registro) {
        registro.setClienteid(null);
        String claveOriginal = registro.getEmail() + registro.getNombres() + registro.getApellidos();
        registro.setLlave_secreta(claveOriginal);
        this.registroService.guardar(registro);
        return registro;
    }

    @PutMapping(value={"/registros"})
    public Registros modificar(@RequestBody Registros registros) {
        this.registroService.modificar(registros);
        return registros;
    }

    @GetMapping(value={"/registros/{id}"})
    public Optional<Registros> buscarId(@PathVariable(value="id") Integer id) {
        return this.registroService.buscarId(id);
    }

    @DeleteMapping(value={"/registros/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.registroService.eliminar(id);
        return "Registro eliminado";
    }

    @PostMapping(value={"/token"})
    public ResponseEntity<?> obtenerToken(@RequestBody Map<String, String> credenciales) {
        String clienteid = credenciales.get("clienteid");
        String llavesecreta = credenciales.get("llave_secreta");
        Optional<Registros> user = this.registroService.buscarTodo().stream().filter(r -> r.getClienteid().equals(clienteid)).findFirst();
        if (user.isPresent() && this.passwordEncoder.matches((CharSequence)llavesecreta, user.get().getLlave_secreta())) {
            String token = this.jwtutil.generarToken(clienteid);
            Registros registro = user.get();
            registro.setAccess_token(token);
            this.registroService.guardar(registro);
            return ResponseEntity.ok(Collections.singletonMap("token", token));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Credenciales incorrectas");
    }
}

