/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Empresas;
import project.fastfood.Entity.Proveedores;
import project.fastfood.Entity.ProveedoresDTO;
import project.fastfood.Repository.EmpresasRepository;
import project.fastfood.Service.IProveedoresService;

@RestController
@RequestMapping(value={"/fastfood"})
public class ProveedorController {
    @Autowired
    private IProveedoresService proveedorService;
    @Autowired
    private EmpresasRepository repoEmpresas;

    @GetMapping(value={"proveedores"})
    public List<Proveedores> buscarTodo() {
        return this.proveedorService.buscarTodo();
    }

    @PostMapping(value={"/proveedores"})
    public ResponseEntity<?> guardar(@RequestBody ProveedoresDTO dto) {
        Proveedores proveedor = new Proveedores();
        proveedor.setRuc(dto.getRuc());
        proveedor.setRazon_social(dto.getRazon_social());
        proveedor.setDireccion(dto.getDireccion());
        proveedor.setTelefono(dto.getTelefono());
        proveedor.setEmail(dto.getEmail());
        Empresas empresa = this.repoEmpresas.findById((Object)dto.getId_empresa()).orElse(null);
        proveedor.setId_empresa(empresa);
        if (empresa == null) {
            return ResponseEntity.badRequest().body((Object)"Empresa no encontrada");
        }
        return ResponseEntity.ok((Object)this.proveedorService.guardar(proveedor));
    }

    @PutMapping(value={"/proveedores"})
    public ResponseEntity<?> modificar(@RequestBody ProveedoresDTO dto) {
        if (dto.getId_proveedor() == null) {
            return ResponseEntity.badRequest().body((Object)"Id proveedor es necesario para modificar");
        }
        Proveedores proveedor = new Proveedores();
        proveedor.setId_proveedor(dto.getId_proveedor());
        proveedor.setRuc(dto.getRuc());
        proveedor.setRazon_social(dto.getRazon_social());
        proveedor.setDireccion(dto.getDireccion());
        proveedor.setTelefono(dto.getTelefono());
        proveedor.setEmail(dto.getEmail());
        Empresas empresa = this.repoEmpresas.findById((Object)dto.getId_empresa()).orElse(null);
        proveedor.setId_empresa(empresa);
        return ResponseEntity.ok((Object)this.proveedorService.modificar(proveedor));
    }

    @GetMapping(value={"/proveedores/{id}"})
    public Optional<Proveedores> buscarId(@PathVariable(value="id") Integer id) {
        return this.proveedorService.buscarId(id);
    }

    @DeleteMapping(value={"/proveedores/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.proveedorService.eliminar(id);
        return "Proveedor eliminado";
    }
}

