/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Productos;
import project.fastfood.Entity.ProductosDTO;
import project.fastfood.Entity.Sucursales;
import project.fastfood.Repository.SucursalRepository;
import project.fastfood.Service.IProductosService;

@RestController
@RequestMapping(value={"/fastfood"})
public class ProductosController {
    @Autowired
    private IProductosService serviceProductos;
    @Autowired
    private SucursalRepository repoSucursal;

    @GetMapping(value={"/productos"})
    public List<Productos> buscartodos() {
        return this.serviceProductos.buscarTodos();
    }

    @PostMapping(value={"/productos"})
    public ResponseEntity<?> guardar(@RequestBody ProductosDTO dto) {
        Productos producto = new Productos();
        producto.setNombre(dto.getNombre());
        producto.setDescripcion(dto.getDescripcion());
        producto.setPrecio_compra(dto.getPrecio_compra());
        producto.setPrecio_venta(dto.getPrecio_venta());
        producto.setStock(dto.getStock());
        producto.setImagen_url(dto.getImagen_url());
        producto.setCategoria(dto.getCategoria());
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        producto.setId_sucursal(sucursal);
        return ResponseEntity.ok((Object)this.serviceProductos.guardar(producto));
    }

    @PutMapping(value={"/productos"})
    public ResponseEntity<?> modificar(@RequestBody ProductosDTO dto) {
        if (dto.getId_producto() == null) {
            return ResponseEntity.badRequest().body((Object)"Id producto es necesario para modificar");
        }
        Productos producto = new Productos();
        producto.setId_producto(dto.getId_producto());
        producto.setNombre(dto.getNombre());
        producto.setDescripcion(dto.getDescripcion());
        producto.setPrecio_compra(dto.getPrecio_compra());
        producto.setPrecio_venta(dto.getPrecio_venta());
        producto.setStock(dto.getStock());
        producto.setImagen_url(dto.getImagen_url());
        producto.setCategoria(dto.getCategoria());
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        producto.setId_sucursal(sucursal);
        return ResponseEntity.ok((Object)this.serviceProductos.modificar(producto));
    }

    @GetMapping(value={"/productos/{id}"})
    public Optional<Productos> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceProductos.buscarId(id);
    }

    @DeleteMapping(value={"/productos/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceProductos.eliminar(id);
        return "Producto eliminado";
    }
}

