/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Mesas;
import project.fastfood.Entity.Pedidos;
import project.fastfood.Entity.PedidosDTO;
import project.fastfood.Entity.Usuarios;
import project.fastfood.Repository.MesaRepository;
import project.fastfood.Repository.UsuariosRepository;
import project.fastfood.Service.IPedidosService;

@RestController
@RequestMapping(value={"/fastfood"})
public class PedidoController {
    @Autowired
    private IPedidosService pedidoService;
    @Autowired
    private MesaRepository repoMesa;
    @Autowired
    private UsuariosRepository repoUsuarios;

    @GetMapping(value={"pedidos"})
    public List<Pedidos> buscarTodo() {
        return this.pedidoService.buscarTodo();
    }

    @PostMapping(value={"/pedidos"})
    public ResponseEntity<?> guardar(@RequestBody PedidosDTO dto) {
        Pedidos pedidos = new Pedidos();
        pedidos.setFecha_hora(dto.getFecha_hora());
        pedidos.setEstado_pedido(dto.getEstado_pedido());
        Mesas mesa = this.repoMesa.findById((Object)dto.getId_mesa()).orElse(null);
        Usuarios usuario = this.repoUsuarios.findById((Object)dto.getId_usuario()).orElse(null);
        pedidos.setId_mesa(mesa);
        pedidos.setId_usuario(usuario);
        return ResponseEntity.ok((Object)this.pedidoService.guardar(pedidos));
    }

    @PutMapping(value={"/pedidos"})
    public ResponseEntity<?> modificar(@RequestBody PedidosDTO dto) {
        if (dto.getId_pedido() == null) {
            return ResponseEntity.badRequest().body((Object)"Id pedido es necesario para modificar");
        }
        Pedidos pedidos = new Pedidos();
        pedidos.setId_pedido(dto.getId_pedido());
        pedidos.setFecha_hora(dto.getFecha_hora());
        pedidos.setEstado_pedido(dto.getEstado_pedido());
        pedidos.setId_usuario(new Usuarios(dto.getId_usuario()));
        pedidos.setId_mesa(new Mesas(dto.getId_mesa()));
        return ResponseEntity.ok((Object)this.pedidoService.modificar(pedidos));
    }

    @GetMapping(value={"/pedidos/{id}"})
    public Optional<Pedidos> buscarId(@PathVariable(value="id") Integer id) {
        return this.pedidoService.buscarId(id);
    }

    @DeleteMapping(value={"/pedidos/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.pedidoService.eliminar(id);
        return "Pedido eliminado";
    }
}

