/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Mesas;
import project.fastfood.Entity.MesasDTO;
import project.fastfood.Entity.Sucursales;
import project.fastfood.Repository.SucursalRepository;
import project.fastfood.Service.IMesasService;

@RestController
@RequestMapping(value={"/fastfood"})
public class MesasController {
    @Autowired
    private IMesasService mesaService;
    @Autowired
    private SucursalRepository repoSucursal;

    @GetMapping(value={"/mesas"})
    public List<Mesas> buscarTodo() {
        return this.mesaService.buscarTodo();
    }

    @PostMapping(value={"/mesas"})
    public ResponseEntity<?> guardar(@RequestBody MesasDTO dto) {
        Mesas mesa = new Mesas();
        mesa.setNombre(dto.getNombre());
        mesa.setEstado_mesa(dto.getEstado_mesa());
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        mesa.setId_sucursal(sucursal);
        return ResponseEntity.ok((Object)this.mesaService.guardar(mesa));
    }

    @PutMapping(value={"/mesas"})
    public ResponseEntity<?> modificar(@RequestBody MesasDTO dto) {
        if (dto.getId_mesa() == null) {
            return ResponseEntity.badRequest().body((Object)"Id mesa es necesario para modificar");
        }
        Mesas mesa = new Mesas();
        mesa.setId_mesa(dto.getId_mesa());
        mesa.setNombre(dto.getNombre());
        mesa.setEstado_mesa(dto.getEstado_mesa());
        mesa.setId_sucursal(new Sucursales(dto.getId_sucursal()));
        return ResponseEntity.ok((Object)this.mesaService.modificar(mesa));
    }

    @GetMapping(value={"/mesas/{id}"})
    public Optional<Mesas> buscarId(@PathVariable(value="id") Integer id) {
        return this.mesaService.buscarId(id);
    }

    @DeleteMapping(value={"/mesas/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.mesaService.eliminar(id);
        return "Mesa eliminado";
    }
}

