/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Inventario;
import project.fastfood.Entity.InventarioDTO;
import project.fastfood.Entity.Productos;
import project.fastfood.Entity.Sucursales;
import project.fastfood.Repository.ProductosRepository;
import project.fastfood.Repository.SucursalRepository;
import project.fastfood.Service.IInventarioService;

@RestController
@RequestMapping(value={"/fastfood"})
public class InventarioController {
    @Autowired
    private IInventarioService inventarioService;
    @Autowired
    private SucursalRepository repoSucursal;
    @Autowired
    private ProductosRepository repoProductos;

    @GetMapping(value={"inventario"})
    public List<Inventario> buscarTodo() {
        return this.inventarioService.buscarTodos();
    }

    @PostMapping(value={"/inventario"})
    public ResponseEntity<?> guardar(@RequestBody InventarioDTO dto) {
        Inventario inventario = new Inventario();
        inventario.setCantidad(dto.getCantidad());
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        Productos producto = this.repoProductos.findById((Object)dto.getId_producto()).orElse(null);
        inventario.setId_sucursal(sucursal);
        inventario.setId_producto(producto);
        return ResponseEntity.ok((Object)this.inventarioService.guardar(inventario));
    }

    @PutMapping(value={"/inventario"})
    public ResponseEntity<?> modificar(@RequestBody InventarioDTO dto) {
        if (dto.getId_inventario() == null) {
            return ResponseEntity.badRequest().body((Object)"Id inventario es necesario para modificar");
        }
        Inventario inventario = new Inventario();
        inventario.setId_inventario(dto.getId_inventario());
        inventario.setCantidad(dto.getCantidad());
        inventario.setId_sucursal(new Sucursales(dto.getId_sucursal()));
        inventario.setId_producto(new Productos(dto.getId_producto()));
        return ResponseEntity.ok((Object)this.inventarioService.modificar(inventario));
    }

    @GetMapping(value={"/inventario/{id}"})
    public Optional<Inventario> buscarId(@PathVariable(value="id") Integer id) {
        return this.inventarioService.buscarId(id);
    }

    @DeleteMapping(value={"/inventario/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.inventarioService.eliminar(id);
        return "Inventario eliminado";
    }
}

