/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Empresas;
import project.fastfood.Service.IEmpresasService;

@RestController
@RequestMapping(value={"/fastfood"})
public class EmpresasController {
    @Autowired
    private IEmpresasService empresasService;

    @GetMapping(value={"empresas"})
    public List<Empresas> buscarTodos() {
        return this.empresasService.buscarTodos();
    }

    @PostMapping(value={"/empresas"})
    public Empresas guardar(@RequestBody Empresas empresas) {
        this.empresasService.guardar(empresas);
        return empresas;
    }

    @PutMapping(value={"/empresas"})
    public Empresas modificar(@RequestBody Empresas empresas) {
        this.empresasService.modificar(empresas);
        return empresas;
    }

    @GetMapping(value={"/empresas/{id}"})
    public Optional<Empresas> buscarId(@PathVariable(value="id") Integer id) {
        return this.empresasService.buscarId(id);
    }

    @DeleteMapping(value={"/empresas/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.empresasService.eliminar(id);
        return "Empresa eliminada";
    }
}

