/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.DetallesPedido;
import project.fastfood.Entity.DetallesPedidoDTO;
import project.fastfood.Entity.Pedidos;
import project.fastfood.Entity.Productos;
import project.fastfood.Repository.PedidoRepository;
import project.fastfood.Repository.ProductosRepository;
import project.fastfood.Service.IDetallesPedidoService;

@RestController
@RequestMapping(value={"/fastfood"})
public class DetallesPedidoController {
    @Autowired
    private IDetallesPedidoService detalleService;
    @Autowired
    private PedidoRepository repoPedido;
    @Autowired
    private ProductosRepository repoProducto;

    @GetMapping(value={"detallespedido"})
    public List<DetallesPedido> buscarTodo() {
        return this.detalleService.buscarTodo();
    }

    @PostMapping(value={"/detallespedido"})
    public ResponseEntity<?> guardar(@RequestBody DetallesPedidoDTO dto) {
        DetallesPedido detalle = new DetallesPedido();
        detalle.setCantidad(dto.getCantidad());
        detalle.setPrecio_unitario(dto.getPrecio_unitario());
        Pedidos pedido = this.repoPedido.findById((Object)dto.getId_pedido()).orElse(null);
        Productos producto = this.repoProducto.findById((Object)dto.getId_producto()).orElse(null);
        detalle.setId_pedido(pedido);
        detalle.setId_producto(producto);
        return ResponseEntity.ok((Object)this.detalleService.guardar(detalle));
    }

    @PutMapping(value={"/detallespedido"})
    public ResponseEntity<?> modificar(@RequestBody DetallesPedidoDTO dto) {
        if (dto.getId_detalle_pedido() == null) {
            return ResponseEntity.badRequest().body((Object)"Id detalle de pedido es necesario para modificar");
        }
        DetallesPedido detalle = new DetallesPedido();
        detalle.setId_detalle_pedido(dto.getId_detalle_pedido());
        detalle.setCantidad(dto.getCantidad());
        detalle.setPrecio_unitario(dto.getPrecio_unitario());
        Pedidos pedido = this.repoPedido.findById((Object)dto.getId_pedido()).orElse(null);
        Productos producto = this.repoProducto.findById((Object)dto.getId_producto()).orElse(null);
        detalle.setId_pedido(pedido);
        detalle.setId_producto(producto);
        return ResponseEntity.ok((Object)this.detalleService.modificar(detalle));
    }

    @GetMapping(value={"/detallespedido/{id}"})
    public Optional<DetallesPedido> buscarId(@PathVariable(value="id") Integer id) {
        return this.detalleService.buscarId(id);
    }

    @DeleteMapping(value={"/detallespedido/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.detalleService.eliminar(id);
        return "detalle pedido eliminado";
    }
}

