/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Compras;
import project.fastfood.Entity.DetallesCompra;
import project.fastfood.Entity.DetallesCompraDTO;
import project.fastfood.Entity.Productos;
import project.fastfood.Repository.ComprasRepository;
import project.fastfood.Repository.ProductosRepository;
import project.fastfood.Service.IDetallesCompraService;

@RestController
@RequestMapping(value={"/fastfood"})
public class DetallesComprasController {
    @Autowired
    private IDetallesCompraService detalleService;
    @Autowired
    private ComprasRepository repoCompra;
    @Autowired
    private ProductosRepository repoProducto;

    @GetMapping(value={"detalles-compra"})
    public List<DetallesCompra> buscarTodo() {
        return this.detalleService.buscarTodo();
    }

    @PostMapping(value={"/detalles-compra"})
    public ResponseEntity<?> guardar(@RequestBody DetallesCompraDTO dto) {
        DetallesCompra detalle = new DetallesCompra();
        detalle.setCantidad(dto.getCantidad());
        detalle.setPrecio_unitario(dto.getPrecio_unitario());
        Compras compra = this.repoCompra.findById((Object)dto.getId_compra()).orElse(null);
        Productos producto = this.repoProducto.findById((Object)dto.getId_producto()).orElse(null);
        detalle.setId_compra(compra);
        detalle.setId_producto(producto);
        return ResponseEntity.ok((Object)this.detalleService.guardar(detalle));
    }

    @PutMapping(value={"/detalles-compra"})
    public ResponseEntity<?> modificar(@RequestBody DetallesCompraDTO dto) {
        if (dto.getId_detalle_compra() == null) {
            return ResponseEntity.badRequest().body((Object)"Id detalle de compra es necesario para modificar");
        }
        DetallesCompra detalle = new DetallesCompra();
        detalle.setId_detalle_compra(dto.getId_detalle_compra());
        detalle.setCantidad(dto.getCantidad());
        detalle.setPrecio_unitario(dto.getPrecio_unitario());
        detalle.setId_compra(new Compras(dto.getId_compra()));
        detalle.setId_producto(new Productos(dto.getId_producto()));
        return ResponseEntity.ok((Object)this.detalleService.modificar(detalle));
    }

    @GetMapping(value={"/detalles-compra/{id}"})
    public Optional<DetallesCompra> buscarId(@PathVariable(value="id") Integer id) {
        return this.detalleService.buscarId(id);
    }

    @DeleteMapping(value={"/detalles-compra/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.detalleService.eliminar(id);
        return "Detalle de compra eliminado";
    }
}

