/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Compras;
import project.fastfood.Entity.ComprasDTO;
import project.fastfood.Entity.Proveedores;
import project.fastfood.Entity.Sucursales;
import project.fastfood.Entity.Usuarios;
import project.fastfood.Repository.ProveedorRepository;
import project.fastfood.Repository.SucursalRepository;
import project.fastfood.Repository.UsuariosRepository;
import project.fastfood.Service.IComprasService;

@RestController
@RequestMapping(value={"/fastfood"})
public class ComprasController {
    @Autowired
    private IComprasService comprasService;
    @Autowired
    private ProveedorRepository repoProveedor;
    @Autowired
    private SucursalRepository repoSucursal;
    @Autowired
    private UsuariosRepository repoUsuarios;

    @GetMapping(value={"compras"})
    public List<Compras> buscarTodo() {
        return this.comprasService.buscarTodo();
    }

    @PostMapping(value={"/compras"})
    public ResponseEntity<?> guardar(@RequestBody ComprasDTO dto) {
        Compras compra = new Compras();
        compra.setFecha_compra(dto.getFecha_compra());
        compra.setTotal_compra(dto.getTotal_compra());
        Proveedores proveedor = this.repoProveedor.findById((Object)dto.getId_proveedor()).orElse(null);
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        Usuarios usuario = this.repoUsuarios.findById((Object)dto.getId_usuario()).orElse(null);
        compra.setId_proveedor(proveedor);
        compra.setId_sucursal(sucursal);
        compra.setId_usuario(usuario);
        return ResponseEntity.ok((Object)this.comprasService.guardar(compra));
    }

    @PutMapping(value={"/compras"})
    public ResponseEntity<?> modificar(@RequestBody ComprasDTO dto) {
        if (dto.getId_compra() == null) {
            return ResponseEntity.badRequest().body((Object)"Id compra es necesario para modificar");
        }
        Compras compra = new Compras();
        compra.setId_compra(dto.getId_compra());
        compra.setFecha_compra(dto.getFecha_compra());
        compra.setTotal_compra(dto.getTotal_compra());
        compra.setId_proveedor(new Proveedores(dto.getId_proveedor()));
        compra.setId_sucursal(new Sucursales(dto.getId_sucursal()));
        compra.setId_usuario(new Usuarios(dto.getId_usuario()));
        return ResponseEntity.ok((Object)this.comprasService.modificar(compra));
    }

    @GetMapping(value={"/compras/{id}"})
    public Optional<Compras> buscarId(@PathVariable(value="id") Integer id) {
        return this.comprasService.buscarId(id);
    }

    @DeleteMapping(value={"/compras/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.comprasService.eliminar(id);
        return "Compra eliminada";
    }
}

