/*
 * Decompiled with CFR 0.152.
 */
package project.fastfood.Controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import project.fastfood.Entity.Cajas;
import project.fastfood.Entity.CajasDTO;
import project.fastfood.Entity.Sucursales;
import project.fastfood.Repository.SucursalRepository;
import project.fastfood.Service.ICajasService;

@RestController
@RequestMapping(value={"/fastfood"})
public class CajasController {
    @Autowired
    private ICajasService serviceCajas;
    @Autowired
    private SucursalRepository repoSucursal;

    @GetMapping(value={"/cajas"})
    public List<Cajas> buscartodos() {
        return this.serviceCajas.buscarTodos();
    }

    @PostMapping(value={"/cajas"})
    public ResponseEntity<?> guardar(@RequestBody CajasDTO dto) {
        Cajas caja = new Cajas();
        caja.setNombre_caja(dto.getNombre_caja());
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        caja.setId_sucursal(sucursal);
        return ResponseEntity.ok((Object)this.serviceCajas.guardar(caja));
    }

    @PutMapping(value={"/cajas"})
    public ResponseEntity<?> modificar(@RequestBody CajasDTO dto) {
        if (dto.getId_caja() == null) {
            return ResponseEntity.badRequest().body((Object)"Id caja es necesario para modificar");
        }
        Cajas caja = new Cajas();
        caja.setId_caja(dto.getId_caja());
        caja.setNombre_caja(dto.getNombre_caja());
        Sucursales sucursal = this.repoSucursal.findById((Object)dto.getId_sucursal()).orElse(null);
        caja.setId_sucursal(sucursal);
        return ResponseEntity.ok((Object)this.serviceCajas.modificar(caja));
    }

    @GetMapping(value={"/cajas/{id}"})
    public Optional<Cajas> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceCajas.buscarId(id);
    }

    @DeleteMapping(value={"/cajas/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceCajas.eliminar(id);
        return "caja eliminado";
    }
}

